package kochModel;
import java.awt.*;
import fp.*;

/**
 * The abstract state of Koch.   This embodies the notion of  Koch being in either a base or non-base case state.
 * Since the grow and paint methods of Koch depend on its state, they are dispatched on out to the concrete states polymorphically.
 * For these internal methods calls, an extra parameter is added; the Koch object which is the context under which
 * the method is operating.  All references to the  actual Koch object go through the public accessor methods.
 */
public abstract class AKochState {
 
 abstract <R,P> R execute(Koch host, IKochVisitor<R,P> algo, P...param);
 abstract <R,P> R fold(Koch host, IFoldAlgo<Koch,R,P> algo, R base, P... param);

}
